<?php
/**
 * TM-Wizard configuration.
 *
 * @var array
 *
 * @package Johnnygo
 */

$plugins = array(
	'cherry-data-importer' => array(
		'name'   => esc_html__( 'Cherry Data Importer', 'johnnygo' ),
		'source' => 'remote', // 'local', 'remote', 'wordpress' (default).
		'path'   => 'https://github.com/CherryFramework/cherry-data-importer/archive/master.zip',
		'access' => 'base',
	),
	'cherry-projects' => array(
		'name'   => esc_html__( 'Cherry Projects', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-popups' => array(
		'name'   => esc_html__( 'Cherry PopUps', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-team-members' => array(
		'name'   => esc_html__( 'Cherry Team Members', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-testi' => array(
		'name'   => esc_html__( 'Cherry Testimonials', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-search' => array(
		'name'   => esc_html__( 'Cherry Search', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-services-list' => array(
		'name'   => esc_html__( 'Cherry Services List', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-sidebars' => array(
		'name'   => esc_html__( 'Cherry Sidebars', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-socialize' => array(
		'name'   => esc_html__( 'Cherry Socialize', 'johnnygo' ),
		'access' => 'skins',
	),
	'cherry-trending-posts' => array(
		'name'   => esc_html__( 'Cherry Trending Posts', 'johnnygo' ),
		'access' => 'skins',
	),
	'booked' => array(
		'name'   => esc_html__( 'Booked Appointments', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . '/assets/includes/plugins/booked.zip',
		'access' => 'skins',
	),
	'elementor' => array(
		'name'   => esc_html__( 'Elementor Page Builder', 'johnnygo' ),
		'access' => 'base',
	),
	'jet-elements' => array(
		'name'   => esc_html__( 'Jet Elements addon For Elementor', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . '/assets/includes/plugins/jet-elements.zip',
		'access' => 'base',
	),
	'tm-mega-menu' => array(
		'name'   => esc_html__( 'TM Mega Menu', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . '/assets/includes/plugins/tm-mega-menu.zip',
		'access' => 'base',
	),
	'jet-menu' => array(
		'name'   => esc_html__( 'Jet menu', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . ( '/assets/includes/plugins/jet-menu.zip' ),
		'access' => 'base',
	),
	'jetsticky-for-elementor' => array(
		'name'   => esc_html__( 'Jet Sticky For Elementor', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . ( '/assets/includes/plugins/jetsticky-for-elementor.zip' ),
		'access' => 'skin',
	),
	'tm-photo-gallery' => array(
		'name'   => esc_html__( 'TM Photo Gallery', 'johnnygo' ),
		'access' => 'skins',
	),
	'tm-timeline' => array(
		'name'   => esc_html__( 'TM Timeline', 'johnnygo' ),
		'access' => 'skins',
	),
	'contact-form-7' => array(
		'name'   => esc_html__( 'Contact Form 7', 'johnnygo' ),
		'access' => 'skins',
	),
	'simple-file-downloader' => array(
		'name'   => esc_html__( 'Simple File Downloader', 'johnnygo' ),
		'access' => 'skins',
	),
	'shortcode-widget' => array(
		'name'   => esc_html__( 'Shortcode Widget', 'johnnygo' ),
		'access' => 'skins',
	),
	'woocommerce' => array(
		'name'   => esc_html__( 'Woocommerce', 'johnnygo' ),
		'access' => 'skins',
	),
	'tm-woocommerce-ajax-filters' => array(
		'name'   => esc_html__( 'TM Woocommerce Ajax Filters', 'johnnygo' ),
		'source' => 'remote',
		'path'   => 'https://github.com/ZemezLab/tm-woocommerce-ajax-filters/archive/master.zip',
		'access' => 'skins',
	),
	'tm-woocommerce-compare-wishlist' => array(
		'name'   => esc_html__( 'TM Woocommerce Compare Wishlist', 'johnnygo' ),
		'access' => 'skins',
	),
	'tm-woocommerce-package' => array(
		'name'   => esc_html__( 'TM Woocommerce Package', 'johnnygo' ),
		'access' => 'skins',
	),
	'tm-woocommerce-quick-view' => array(
		'name'   => esc_html__( 'TM WooCommerce Quick View', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . '/assets/includes/plugins/tm-woocommerce-quick-view.zip',
		'access' => 'skins',
	),
	'rev-slider' => array(
		'name'   => esc_html__( 'Revolution Slider', 'johnnygo' ),
		'source' => 'local',
		'path'   => JOHNNYGO_THEME_DIR . '/assets/includes/plugins/revslider.zip',
		'access' => 'skins',
	),
	'tm-dashboard' => array(
		'name'   => esc_html__( 'Jetimpex Dashboard', 'johnnygo' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-dashboard.zip',
		'access' => 'base',
	),
	'wordpress-social-login' => array(
		'name'   => esc_html__( 'WordPress Social Login', 'johnnygo' ),
		'access' => 'skins',
	),
	'woocommerce-social-media-share-buttons' => array(
		'name'   => esc_html__( 'Woocommerce Social Media Share Buttons', 'johnnygo' ),
		'access' => 'skins',
	),
);

$full_plugins_list = array(
	'booked',
	'cherry-projects',
	'cherry-popups',
	'cherry-search',
	'cherry-services-list',
	'cherry-sidebars',
	'cherry-socialize',
	'cherry-team-members',
	'cherry-testi',
	'cherry-trending-posts',
	'tm-photo-gallery',
	'tm-timeline',
	'jetsticky-for-elementor',
	'contact-form-7',
	'simple-file-downloader',
	'rev-slider',
	'shortcode-widget',
	'woocommerce',
	'tm-woocommerce-ajax-filters',
	'tm-woocommerce-compare-wishlist',
	'tm-woocommerce-package',
	'tm-woocommerce-quick-view',
	'wordpress-social-login',
	'woocommerce-social-media-share-buttons',
);

$skins_import_config  = johnnygo_skins_import_config();
$skins_plugins_config = array();

foreach ( $skins_import_config as $skin => $config ) {

	$skins_plugins_config[ $skin ] = array(
		'full'  => $full_plugins_list,
		'lite'  => false,
		'demo'  => $config['demo_url'],
		'thumb' => $config['thumb'],
		'name'  => $config['label'],
	);

}

$skins_plugins_config[ 'servistar' ]  = array(
	'full'  => array(
		'booked',
		'cherry-popups',
		'cherry-search',
		'cherry-sidebars',
		'cherry-socialize',
		'cherry-trending-posts',
		'tm-timeline',
		'jetsticky-for-elementor',
		'contact-form-7',
		'simple-file-downloader',
		'rev-slider',
		'shortcode-widget',
		'woocommerce',
		'tm-woocommerce-ajax-filters',
		'tm-woocommerce-compare-wishlist',
		'tm-woocommerce-package',
		'tm-woocommerce-quick-view',
		'wordpress-social-login',
		'woocommerce-social-media-share-buttons',
	),
	'lite'  => false,
	'demo' => 'https://ld-wp.template-help.com/wordpress_62555/4/moving-2/',
	'thumb'    => get_template_directory_uri() . '/assets/demo-content/servistar/servistar-thumb.jpg',
	'name'  => esc_html__( 'Moving Services', 'johnnygo' ),
);

$skins_plugins_config[ 'roofing-2' ]  = array(
	'full'  => array(
		'cherry-socialize',
		'contact-form-7',
	),
	'lite'  => false,
	'demo' => 'https://ld-wp.template-help.com/wordpress_62555/4/roofing-2/',
	'thumb'    => get_template_directory_uri() . '/assets/demo-content/roofing-2/roofing-2-thumb.jpg',
	'name'  => esc_html__( 'Roofing Services', 'johnnygo' ),
);

$skins_plugins_config[ 'painter-2' ]  = array(
	'full'  => array(
		'contact-form-7',
	),
	'lite'  => false,
	'demo' => 'https://ld-wp.template-help.com/wordpress_62555/4/painter-2/',
	'thumb'    => get_template_directory_uri() . '/assets/demo-content/painter-2/painter-2-thumb.jpg',
	'name'  => esc_html__( 'Painting Services', 'johnnygo' ),
);

/**
 * Skins configuration.
 *
 * @var array
 */
$skins = array(
	'base' => array(
		'cherry-data-importer',
		'tm-dashboard',
		'elementor',
		'jet-elements',
		'tm-mega-menu',
		'jet-menu',
	),
	'advanced' => $skins_plugins_config,
);

$texts = array(
	'theme-name' => esc_html__( 'JohnnyGo', 'johnnygo' ),
);
