<?php

if ( !class_exists( 'Kirki' ) ) {
	return;
}


Kirki::add_panel( 'colors', array(
	'priority'	 => 10,
	'title'		 => esc_attr__( 'Colors and Typography', 'futurio-extra' ),
) );

Kirki::add_section( 'presets_colors_section', array(
	'title'		 => esc_attr__( 'Color presets', 'futurio-extra' ),
	'panel'		 => 'colors',
	'priority'	 => 5,
) );


/**
 * Presets
 */
Kirki::add_field( 'futurio_extra', array(
	'type'        => 'palette',
	'settings'    => 'color_preset',
	'label'       => esc_attr__( 'Color presets', 'futurio-extra' ),
	'section'     => 'presets_colors_section',
	'default'     => 'default_blue',
	'priority'    => 10,
	'choices'     => array(
		'default_blue' => array(
			'#FFFFFF',
			'#00aff2',
		),
		'white_red' => array(
			'#FFFFFF',
			'#dd3333',
      '#8c1c1c',
		),
    'white_green' => array(
			'#FFFFFF',
			'#3fcc46',
      '#417f26',
		),
    'dark_orange' => array(
			'#383838',
			'#dd9933',
      '#a35725',
		),
	),
) );

/**
 * Add custom CSS styles
 */
function futurio_extra_presets_css() {

	$preset = get_theme_mod( 'color_preset', 'default_blue' );

	if ( 'default_blue' === $preset ) {
    $css = '';
	} elseif ( 'white_red' === $preset ) {
		$css = '.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle{background-color:#dd3333;}a, .author-meta a, .tags-links a, nav.navigation.pagination .nav-links a{color:#dd3333;}.widget-title:before, nav.navigation.pagination .current:before, .cart-contents span.count{background-color:#dd3333;}nav.navigation.pagination .current:before{border-color:#dd3333;}a:active, a:hover, a:focus, .tags-links a:hover{color:#8c1c1c;}.read-more-button a, #searchsubmit, .btn-default, input[type="submit"], input#submit, input#submit:hover, button, a.comment-reply-link, .btn-default:hover, input[type="submit"]:hover, button:hover, a.comment-reply-link:hover{color:#dd3333;border-color:#dd3333;}.top-bar-section{background-color:#f4f4f4;color:#515151;}.top-bar-section a{color:#dd3333;}.top-bar-section a:hover{color:#8c1c1c;}.site-header{background-color:#ffffff;}#site-navigation .navbar-nav > li > a:hover, #site-navigation .dropdown-menu > li > a:hover, #site-navigation .nav > li > a:before{color:#dd3333;}#site-navigation .nav > li > a:before, #site-navigation .nav > li.active > a:before, #site-navigation .current-page-parent:before{background-color:#dd3333;}#site-navigation .navbar-nav > li.active > a, #site-navigation .dropdown-menu > .active > a, .home-icon.front_page_on i{color:#ffffff;}#site-navigation .navbar-nav > li.active > a, #site-navigation .dropdown-menu > .active > a, li.home-icon.front_page_on, li.home-icon.front_page_on:before{background-color:#dd3333;}.footer-credits, .footer-credits-text{background-color:#ffffff;color:#0a0a0a;}.footer-credits a{color:#dd3333;}.footer-credits a:hover{color:#8c1c1c;}.woocommerce ul.products li.product h3, li.product-category.product h3, .woocommerce ul.products li.product h2.woocommerce-loop-product__title, .woocommerce ul.products li.product h2.woocommerce-loop-category__title{color:#0a0a0a;}.woocommerce ul.products li.product .price{color:#dd3333;}.woocommerce .star-rating span{color:#dd3333;}.woocommerce ul.products li.product .button{color:#dd3333;}.woocommerce ul.products li.product .button:hover{color:#ffffff;background-color:#8c1c1c;}.woocommerce span.onsale, .single .woocommerce .related span.onsale{color:#ffffff;background-color:#dd3333;}.woocommerce .summary .star-rating span{color:#dd3333;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a{color:#dd3333;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li:hover a{border-bottom-color:#dd3333;}.woocommerce div.product .woocommerce-tabs ul.tabs li a{color:#dd3333;}.single.woocommerce span.onsale{color:#ffffff;background-color:#dd3333;}.woocommerce #respond input#submit, .woocommerce a.button, #sidebar .widget.widget_shopping_cart a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{color:#dd3333;}.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{background-color:transparent;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, #sidebar .widget.widget_shopping_cart a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{color:#ffffff;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{background-color:#8c1c1c;}@media (max-width: 767px){#site-navigation .navbar-nav a:hover{color:#dd3333!important;}#site-navigation .navbar-nav .active > a{color:#ffffff!important;background-color:#dd3333!important;}}';
	} elseif ( 'white_green' === $preset ) {
		$css = '.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle{background-color:#3fcc46;}a, .author-meta a, .tags-links a, nav.navigation.pagination .nav-links a{color:#3fcc46;}.widget-title:before, nav.navigation.pagination .current:before, .cart-contents span.count{background-color:#3fcc46;}nav.navigation.pagination .current:before{border-color:#3fcc46;}a:active, a:hover, a:focus, .tags-links a:hover{color:#417f26;}.read-more-button a, #searchsubmit, .btn-default, input[type="submit"], input#submit, input#submit:hover, button, a.comment-reply-link, .btn-default:hover, input[type="submit"]:hover, button:hover, a.comment-reply-link:hover{color:#3fcc46;border-color:#3fcc46;}.top-bar-section{background-color:#f4f4f4;color:#515151;}.top-bar-section a{color:#3fcc46;}.top-bar-section a:hover{color:#417f26;}.site-header{background-color:#ffffff;}#site-navigation .navbar-nav > li > a:hover, #site-navigation .dropdown-menu > li > a:hover, #site-navigation .nav > li > a:before{color:#3fcc46;}#site-navigation .nav > li > a:before, #site-navigation .nav > li.active > a:before, #site-navigation .current-page-parent:before{background-color:#3fcc46;}#site-navigation .navbar-nav > li.active > a, #site-navigation .dropdown-menu > .active > a, .home-icon.front_page_on i{color:#ffffff;}#site-navigation .navbar-nav > li.active > a, #site-navigation .dropdown-menu > .active > a, li.home-icon.front_page_on, li.home-icon.front_page_on:before{background-color:#3fcc46;}.footer-credits, .footer-credits-text{background-color:#ffffff;color:#0a0a0a;}.footer-credits a{color:#3fcc46;}.footer-credits a:hover{color:#417f26;}.woocommerce ul.products li.product h3, li.product-category.product h3, .woocommerce ul.products li.product h2.woocommerce-loop-product__title, .woocommerce ul.products li.product h2.woocommerce-loop-category__title{color:#0a0a0a;}.woocommerce ul.products li.product .price{color:#3fcc46;}.woocommerce .star-rating span{color:#3fcc46;}.woocommerce ul.products li.product .button{color:#3fcc46;}.woocommerce ul.products li.product .button:hover{color:#ffffff;background-color:#417f26;}.woocommerce span.onsale, .single .woocommerce .related span.onsale{color:#ffffff;background-color:#3fcc46;}.woocommerce .summary .star-rating span{color:#3fcc46;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a{color:#3fcc46;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li:hover a{border-bottom-color:#3fcc46;}.woocommerce div.product .woocommerce-tabs ul.tabs li a{color:#3fcc46;}.single.woocommerce span.onsale{color:#ffffff;background-color:#3fcc46;}.woocommerce #respond input#submit, .woocommerce a.button, #sidebar .widget.widget_shopping_cart a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{color:#3fcc46;}.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{background-color:transparent;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, #sidebar .widget.widget_shopping_cart a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{color:#ffffff;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{background-color:#417f26;}@media (max-width: 767px){#site-navigation .navbar-nav a:hover{color:#3fcc46!important;}#site-navigation .navbar-nav .active > a{color:#ffffff!important;background-color:#3fcc46!important;}}';
	} elseif ( 'dark_orange' === $preset ) {
		$css = '#site-navigation .dropdown-menu>.active>a {background-color: transparent;}, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle{background-color:#dd9933;}.main-container, .container-fluid.head-bread, .offcanvas-sidebar .widget-title h3, #sidebar .widget-title h3, .container-fluid.archive-page-header, .offcanvas-sidebar, .cart-contents span.count, #product-nav > a{background-color:#383838;}a, .author-meta a, .tags-links a, nav.navigation.pagination .nav-links a{color:#dd9933;}.widget-title:before, nav.navigation.pagination .current:before{background-color:#dd9933;}nav.navigation.pagination .current:before{border-color:#dd9933;}a:active, a:hover, a:focus, .tags-links a:hover{color:#a35725;}.read-more-button a, #searchsubmit, .btn-default, input[type="submit"], input#submit, input#submit:hover, button, a.comment-reply-link, .btn-default:hover, input[type="submit"]:hover, button:hover, a.comment-reply-link:hover{color:#ffffff;background-color:#dd9933;border-color:#dd9933;}body, nav.navigation.post-navigation a, .nav-subtitle{color:#dddddd;}.comments-meta a{color:#dddddd;}.news-item h2 a, .page-header, .page-header a, h1.single-title, h1, h2, h3, h4, h5, h6{color:#ffffff;}.top-bar-section{color:#fff;}.site-branding-text h1.site-title a:hover, .site-branding-text .site-title a:hover, .site-branding-text h1.site-title, .site-branding-text .site-title, .site-branding-text h1.site-title a, .site-branding-text .site-title a{color:#ffffff;}p.site-description{color:#a3a3a3;}#site-navigation, #site-navigation .dropdown-menu, #site-navigation.shrink, .header-cart-block:hover ul.site-header-cart{background-color:#2d2d2d;}#site-navigation, #site-navigation .navbar-nav > li > a, #site-navigation .dropdown-menu > li > a, .brand-absolute{color:#ffffff;}.open-panel span{background-color:#ffffff;}.open-panel span, .header-cart a.cart-contents, .header-login a, .top-search-icon i, .offcanvas-sidebar-toggle i, .site-header-cart, .site-header-cart a{color:#ffffff;}#site-navigation .navbar-nav > li > a:hover, #site-navigation .dropdown-menu > li > a:hover, #site-navigation .nav > li > a:before{color:#ffffff;}#site-navigation .nav > li > a:before, #site-navigation .nav > li.active > a:before, #site-navigation .current-page-parent:before{background-color:#ffffff;}#site-navigation .navbar-nav > li > a:hover, #site-navigation .dropdown-menu > li > a:hover, #site-navigation .nav > li > a:before{background-color:#a35725;}#site-navigation .navbar-nav > li.active > a, #site-navigation .dropdown-menu > .active > a, .home-icon.front_page_on i{color:#dd9933;}#sidebar .widget-title h3{color:#ffffff;}#sidebar .widget-title:after, .offcanvas-sidebar .widget-title:after{background-color:#ffffff;}.widget-title h3{border-color:#ffffff;}.widget{color:#e8e8e8;}#content-footer-section, #content-footer-section .widget-title h3{background-color:#5b5b5b;}.single .content-date-comments span{color:#ffffff;}.date-meta{background-color:#dd9933;}.comments-meta, .comments-meta a{color:#0a0a0a;}.comments-meta{background-color:#e5e5e5;}.woocommerce ul.products li.product h3, li.product-category.product h3, .woocommerce ul.products li.product h2.woocommerce-loop-product__title, .woocommerce ul.products li.product h2.woocommerce-loop-category__title{color:#eaeaea;}.woocommerce ul.products li.product .price{color:#dd9933;}.woocommerce ul.products li.product, .woocommerce-page ul.products li.product, li.product-category.product, .woocommerce ul.products li.product .woocommerce-loop-category__title{background:rgba(255,255,255,0);}.woocommerce ul.products li.product .button{color:#ffffff;}.woocommerce ul.products li.product .button:hover{color:#dd9933;}.woocommerce span.onsale, .single .woocommerce .related span.onsale{background-color:#dd9933;}.woocommerce div.product p.price, .woocommerce div.product span.price{color:#dd9933;}.woocommerce .summary .star-rating span{color:#dd9933;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a{color:#dd9933;}.woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs.wc-tabs li:hover a{border-bottom-color:#dd9933;}.woocommerce div.product .woocommerce-tabs ul.tabs li a{color:#a35725;}.woocommerce #respond input#submit, .woocommerce a.button, #sidebar .widget.widget_shopping_cart a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{color:#ffffff;}.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt{border-color:#dd9933;background-color:#dd9933;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, #sidebar .widget.widget_shopping_cart a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{color:#dd9933;}.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{border-color:#dd9933;background-color:#ffffff;}@media (max-width: 767px){#site-navigation .navbar-nav a, .openNav .menu-container{background-color:#2d2d2d;}#site-navigation .navbar-nav a:hover{color:#ffffff!important;background-color:#a35725!important;}#site-navigation .navbar-nav .active a{color:#dd9933!important;}}';
  } else {
		$css = '';
	}
  
	wp_add_inline_style( 'futurio-stylesheet', $css );
}

add_action( 'wp_enqueue_scripts', 'futurio_extra_presets_css', 9999 );
