<?php
/**
 * Newsletter Sign Up Meta Box
 *
 * @package SimpleCalendar/Admin
 */
namespace SimpleCalendar\Admin\Metaboxes;

use SimpleCalendar\Abstracts\Meta_Box;

if (!defined('ABSPATH')) {
	exit();
}

/**
 * Sign up to Simple Calendar newsletter.
 *
 * @since 3.0.0
 */
class Newsletter implements Meta_Box
{
	/**
	 * Output HTML.
	 *
	 * @since 3.0.0
	 *
	 * @param \WP_Post $post
	 */
	public static function html($post)
	{
		simcal_newsletter_signup();
	}

	/**
	 * Save settings.
	 *
	 * @since 3.0.0
	 *
	 * @param int      $post_id
	 * @param \WP_Post $post
	 */
	public static function save($post_id, $post)
	{
		// This meta box has no persistent settings.
	}
}
